<?php
session_start();
$nome = $_SESSION['usuario']['nome'] ?? 'Usuário';
$foto = $_SESSION['usuario']['foto'] ?? 'default.jpg';
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Painel Secretaria Pedagógica</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
  <script src="js/chart.min.js"></script>

  <style>
    body { margin: 0; font-family: 'Segoe UI', sans-serif; background-color: #f4f6f9; }
    .sidebar { width: 260px; background: #001f3f; color: white; position: fixed; top: 0; bottom: 0; padding-top: 60px; }
    .sidebar a { display: block; color: white; padding: 15px 20px; text-decoration: none; }
    .sidebar a:hover { background: #0056b3; }
    .topbar { position: fixed; left: 260px; right: 0; top: 0; height: 60px; background: #003366; color: white; display: flex; align-items: center; justify-content: space-between; padding: 0 20px; }
    .topbar .user-info { display: flex; align-items: center; gap: 10px; }
    .topbar img { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; border: 2px solid white; }
    .main-content { margin-left: 260px; margin-top: 60px; padding: 30px; }
    .grafico-container {
      background: white;
      border-radius: 10px;
      padding: 20px;
      margin-top: 20px;
      display: none;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
  </style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar">
  <a href="mapa_aproveitamento.php"><i class="fas fa-table"></i> Mapas de Aproveitamento</a>
  <a href="mini_pauta.php"><i class="fas fa-table"></i> Gestão de Mini Pautas</a>
  <a href="planificacao_modelo.php"><i class="fas fa-table"></i> Modelo de Planificação</a>
  <a href="ver_turmas.php"><i class="fas fa-table"></i> Cadastrar Dados do Aluno</a>
  <a href="ver_notas_finais.php"><button class="btn btn-primary">Ver Notas Finais</button></a>
  <a href="painel_certificados.php"><i class="fas fa-certificate"></i> Certificados</a>

<a href="pauta_final_aluno.php"><i class="fas fa-certificate"></i>Termo de Frequência e Exame</a>
  <a href="alterar_senha.php"><i class="fas fa-lock"></i> Alterar Senha</a>
  <a href="enviar_documento.php"><i class="fas fa-upload"></i> Enviar Documento</a>
  <a href="#" onclick="mostrarGrafico('coluna')"><i class="fas fa-chart-column"></i> Gráfico de Colunas</a>
  <a href="#" onclick="mostrarGrafico('barra')"><i class="fas fa-chart-bar"></i> Gráfico de Barras</a>
  <a href="login.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
</div>

<!-- Topbar -->
<div class="topbar">
  <div><strong>PEFRICKBG0026</strong> | Bem-vindo, <?= htmlspecialchars($nome) ?></div>
  <div class="user-info">
    <form action="atualizar_foto.php" method="post" enctype="multipart/form-data" id="fotoUploadForm">
      <label for="fotoUpload">
        <img src="fotos/<?= htmlspecialchars($foto) ?>" alt="Foto" id="userPhoto">
      </label>
      <input type="file" name="foto" id="fotoUpload" style="display:none;" onchange="document.getElementById('fotoUploadForm').submit();">
    </form>
    <span><?= htmlspecialchars($nome) ?></span>
  </div>
</div>

<!-- Conteúdo -->
<div class="main-content">
  <h2>Bem-vindo(a), <?= htmlspecialchars($nome) ?>!</h2>
  <p>Selecione uma funcionalidade na barra lateral.</p>

  <!-- Gráfico de Colunas -->
  <div id="grafico-coluna" class="grafico-container">
    <h4>Média por Turma</h4>
    <canvas id="colunaChart" height="100"></canvas>
  </div>

  <!-- Gráfico de Barras -->
  <div id="grafico-barra" class="grafico-container">
    <h4>Média por Disciplina</h4>
    <canvas id="barraChart" height="100"></canvas>
  </div>
</div>

<!-- Script -->
<script>
let colunaChart = null;
let barraChart = null;

function mostrarGrafico(tipo) {
  document.getElementById('grafico-coluna').style.display = 'none';
  document.getElementById('grafico-barra').style.display = 'none';

  if (tipo === 'coluna') {
    document.getElementById('grafico-coluna').style.display = 'block';
    renderizarColuna();
  } else if (tipo === 'barra') {
    document.getElementById('grafico-barra').style.display = 'block';
    renderizarBarra();
  }
}

function renderizarColuna() {
  if (colunaChart) colunaChart.destroy();
  const ctx = document.getElementById('colunaChart').getContext('2d');
  colunaChart = new Chart(ctx, {
    type: 'bar',
    data: {
      labels: ['10ª A', '10ª B', '11ª A', '11ª B'],
      datasets: [{
        label: 'Média por Turma',
        data: [12.5, 11.3, 13.7, 10.9],
        backgroundColor: '#007bff'
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { display: false },
        title: { display: true, text: 'Média por Turma' }
      },
      scales: {
        y: {
          beginAtZero: true,
          max: 20
        }
      }
    }
  });
}

function renderizarBarra() {
  if (barraChart) barraChart.destroy();
  const ctx = document.getElementById('barraChart').getContext('2d');
  barraChart = new Chart(ctx, {
    type: 'bar',
    data: {
      labels: ['Português', 'Matemática', 'Física', 'Química'],
      datasets: [{
        label: 'Média por Disciplina',
        data: [11.2, 9.8, 10.4, 12.3],
        backgroundColor: ['#28a745', '#ffc107', '#17a2b8', '#dc3545']
      }]
    },
    options: {
      responsive: true,
      indexAxis: 'y',
      plugins: {
        legend: { display: false },
        title: { display: true, text: 'Média por Disciplina' }
      },
      scales: {
        x: {
          beginAtZero: true,
          max: 20
        }
      }
    }
  });
}
</script>

</body>
</html>
